# 機能設計書 45-fastapi CLI

## 概要

本ドキュメントは、FastAPIにおけるfastapi CLIの設計と実装について記述する。この機能はコマンドラインインターフェース機能を提供し、開発サーバーの起動等に使用される。

### 本機能の処理概要

**業務上の目的・背景**：開発者がFastAPIアプリケーションを効率的に開発・デバッグするために、コマンドラインから簡単にサーバーを起動できる機能が必要である。fastapi CLIは、uvicornなどのASGIサーバーを直接呼び出すことなく、`fastapi run`や`fastapi dev`といった簡潔なコマンドで開発サーバーを起動することを可能にする。

**機能の利用シーン**：本機能は以下のシーンで利用される：
- 開発環境でのサーバー起動（ホットリロード有効）
- プロダクション環境でのサーバー起動
- アプリケーションのデバッグ時
- 新規プロジェクトの初期動作確認

**主要な処理内容**：
1. コマンドライン引数の解析
2. fastapi-cliパッケージの存在確認
3. 適切なエラーメッセージの表示（パッケージ未インストール時）
4. fastapi-cliのmain関数への処理委譲

**関連システム・外部連携**：fastapi-cliパッケージ（別途インストールが必要）に依存。fastapi-cliは内部的にuvicornを使用してASGIサーバーを起動する。

**権限による制御**：本機能自体は権限制御を行わない。サーバー起動に必要なポートバインドは、OS側の権限に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はCLIツールであり、直接関連する画面はない |

## 機能種別

CLI / 開発支援 / サーバー起動

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | cli.pyは引数を直接受け取らず、fastapi-cliに委譲 | - |

### fastapi-cliコマンド（参考）

| コマンド | 説明 |
|---------|------|
| fastapi run | プロダクションモードでサーバー起動 |
| fastapi dev | 開発モードでサーバー起動（ホットリロード有効） |

### 入力データソース

コマンドライン引数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stdout | str | サーバー起動ログ、エラーメッセージ |
| stderr | str | エラー出力 |

### 出力先

標準出力（stdout）、標準エラー出力（stderr）

## 処理フロー

### 処理シーケンス

```
1. main関数呼び出し
   └─ コマンドラインエントリーポイント
2. fastapi-cliインポート確認
   └─ try: from fastapi_cli.cli import main as cli_main
3. インポート成功時
   └─ cli_main()を呼び出して処理委譲
4. インポート失敗時
   └─ インストール案内メッセージを表示してRuntimeError発生
```

### フローチャート

```mermaid
flowchart TD
    A[main関数呼び出し] --> B{fastapi-cliインポート成功?}
    B -->|Yes| C[cli_main関数呼び出し]
    C --> D[fastapi-cliの処理実行]
    D --> E[サーバー起動等]
    B -->|No| F[インストール案内表示]
    F --> G[RuntimeError発生]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | パッケージ依存 | fastapi-cliパッケージがインストールされている必要がある | CLI使用時 |
| BR-45-02 | インストール案内 | パッケージ未インストール時は`pip install "fastapi[standard]"`を案内 | ImportError発生時 |
| BR-45-03 | 例外発生 | パッケージ未インストール時はRuntimeErrorを発生させる | ImportError発生時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能自体はデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ImportError（内部キャッチ） | fastapi-cliがインストールされていない | `pip install "fastapi[standard]"`を実行 |
| - | RuntimeError | fastapi-cliがインストールされていない | 同上 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- CLI起動は即座に完了すること
- fastapi-cliが存在しない場合のエラー表示は瞬時に行われる

## セキュリティ考慮事項

- 開発サーバー（`fastapi dev`）は本番環境で使用しないこと
- 信頼できないネットワークからのアクセスを許可する設定に注意

## 備考

- cli.pyはfastapi-cliパッケージへの薄いラッパーとして実装されている
- fastapi-cliは`pip install "fastapi[standard]"`でインストール可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

cli.pyの実装構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cli.py | `fastapi/cli.py` | fastapi-cliへの委譲ロジック |

**読解のコツ**: cli.pyは非常にシンプルな実装で、fastapi-cliパッケージの存在確認とエラーハンドリングのみを行っている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cli.py | `fastapi/cli.py` | main関数のエントリーポイント |

**主要処理フロー**:
1. **1-5行目**: fastapi_cli.cliからmainをインポート（失敗時はcli_main=None）
2. **8-13行目**: main関数でcli_mainの存在チェックとエラーハンドリング

#### Step 3: pyproject.tomlでのエントリーポイント定義を確認

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pyproject.toml | `pyproject.toml` | fastapi コマンドのエントリーポイント定義 |

**主要処理フロー**:
- `[project.scripts]`セクションで`fastapi = "fastapi.cli:main"`が定義されている

### プログラム呼び出し階層図

```
fastapi コマンド（シェル）
    │
    └─ fastapi.cli.main()
           │
           ├─ fastapi_cli存在チェック
           │      │
           │      ├─ 存在する → cli_main()呼び出し
           │      │                │
           │      │                └─ fastapi-cliの処理
           │      │                       │
           │      │                       └─ uvicorn起動等
           │      │
           │      └─ 存在しない → エラーメッセージ表示
           │                           │
           │                           └─ RuntimeError発生
           │
           └─ 終了
```

### データフロー図

```
[入力]                    [処理]                           [出力]

コマンドライン引数 ────▶ fastapi.cli.main() ──────────▶ サーバー起動
       │                      │                              or
       └─ fastapi dev app:app ├─ fastapi-cli存在確認        エラーメッセージ
                              │
                              └─ fastapi_cli.cli.main()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cli.py | `fastapi/cli.py` | ソース | CLIエントリーポイント |
| pyproject.toml | `pyproject.toml` | 設定 | コマンドエントリーポイント定義 |
| fastapi_cli/cli.py | `fastapi-cli` パッケージ | 外部 | 実際のCLI実装（別パッケージ） |
